// ****  Globale Symboldefinitionen fr S65 Digitalanzeige

//***********************************************************************
//****																
//**** 						Ein- / Ausgnge	
//****				
//***********************************************************************

// Tastatur/Encoder

#bit Taste1=PortB.7					// Taste 1
#bit Taste2=PortB.6					// Taste 2
#bit Taste3=PortB.5					// Taste 3
#bit Enc_A=PortB.3					// Rotary Encoder Ausgang 0
#bit Enc_B=PortB.2					// Rotary Encoder Ausgang 1
#bit Enc_BT=PortB.1 				// Rotary Encoder Taster

// LCD
#bit LCD_SCLK=LATC.3				// Clock
#bit LCD_SDIN=LATC.5				// Daten
#bit LCD_RESET=LATD.1				// Reset
#bit LCD_RS=LATD.0					// RS
#bit LCD_CS=LATD.2					// /Cip Select

// UART
#bit RS485_TXEN=LatC.0				// TX-Enable fr RS485 Treiber

//***********************************************************************
//****	
//**** 				Initialisierungswerte fr Periferie	
//****		
//***********************************************************************

#define T0_ON_Config 0b10000000		// On, 16-Bit interner Takt 1:4
#define T1_ON_Config 0b00111001		// On, Prescaler 1:8
#define T2_ON_Config 0b00000000		// Off
#define IntCon_Config 0b11100000	// Global, TMR0 und Peripherie enabled
#define InTCon2_Config 0b00000000	// Pull Ups Enabled, alles Low-Priority
#define IntCon3_Config 0b00000000	// alles Low Priority
#define PIE1_Config 0b00100000		// RCIE Enabled;
#define TrisA_Config 0b00000000		// 
#define TrisB_Config 0b11101110		
#define TrisC_Config 0b10000000		// RXD1 (UART) und RXD2 (Software-UART) Eingnge
#define TrisD_Config 0b00000000
#define TrisE_Config 0b00000000

#define PortA_Init 0b00000000
#define PortB_Init 0b11111111
#define PortC_Init 0b00000000
#define PortD_Init 0b00000000
#define PortE_Init 0b00000000


// AD / Comparatorkonfiguration
#define AD_Config0 0b00000000		// AD On
#define AD_Config1 0b00001110		// AD0
//#define AD_config2 0b00111010
#define AD_config2 0b00100010
#define Comp_Config 0b00000111		// Off

// PWM Definitionen
#define CCP1_Config 0b00000000		// Off
#define CCP2_Config 0b00000000
#define PWM1_Config 0b00000000		
#define ECC_Config 0b00000000		

#define RCSTA_Config 0b11110000
#define TXSTA_Config 0b01100100		// BRGH=1, Usart High Speed
#define SPBRG_Config 25				// 38.400Baud


///***********************************************************************
//****	
//**** 							Konstanten	
//****				
//***********************************************************************

#define TMR0StartValue 0xFFFF-2000+24	// Zeitkonstante fr TMR0 Interupt (jede 1ms, alle 4.000 Zyklen)
#define EBuffSize 256					// Empfangspuffergre
#define SBuffSize 256					// Sendepuffergre
#define MaxRS232_Timeout 10				// maximale Zeit zwischen zwei Bytes
#define TastZeit 50						// Tastaturabfrage alle 50ms
#define MessZeit 20						// Messwertabfrage alle 20ms

//***********************************************************************
//****				
//**** 						Globale Variablen		
//****												
//***********************************************************************

// Com1 (UART)
int16 PSBuff=0;						// aktuelle Sendepufferposition
int16 PEBuff=0;						// aktuelle Empfangspufferposition
int SBuff[SBuffSize];				// Sendepuffer 20 Byte
int Ebuff[EBuffSize];				// Empfangspuffer 20 Byte
int ZSend=0;						// Anzahl zu sendender Bytes

short _EmpfangAktiv=false;			// momentaner Datenempfang ber RS232
short _DatenEmpfangen=false;		// Datensatz komplett empfangen
int RSXXX_Timeout=0;				// Timeout bei Datenempfang zwischen zwei Bytes
int AbsTimeOutTimer=0;				// Timeout bei Datenempfang bis Antwort
int TastaturTimer=0;				// Timer fr Tastaturabfrage
short _TastAbfrage=false;			// Tastatur abfragen?
int LastPressed=0;					// zuletzt gedrckte Taste
int MessTimer=0;					// Timer fr Messwertabfragen
short _MesswertAbfrage=false;	

signed int EncValue=0;				// Wert des Rotary Encoders
short _Alt_Enc_A;					// Merker fr letzte Stellung

int SysMode=0;						// Systemmodus 0 --> Anzeige / 1 --> Parametrierung

signed int16 XOffset;				// Offsetwerte fr Achsen in mm
signed int16 YOffset;
signed int16 ZOffset;
signed int32 XSOffset;				// Offsetwerte fr Achsen in 1/2048mm
signed int32 YSOffset;
signed int32 ZSOffset;
int MaschType;						// Maschinentyp 0 --> Frsmaschine / 1 --> Drehmaschine

char LCDStr[32];
